require(['jquery', 'xwiki-meta'], function ($, xm) {

  $(document).ready(function() {
    var input = $('.notificationAutoWatchMode');
    input.change( function (event) {
      var target = input.data('target') == 'wiki' ? 'wiki' : 'user';
      var notification = new XWiki.widgets.Notification("Your settings are being saved...", 'inprogress');
      var url = "https://xwiki.e-lise.nl:80/wiki/elise/get/XWiki/Notifications/Code/NotificationPreferenceService?outputSyntax=plain";
      $.post(url, {
        action: target == 'user' ? 'setAutoWatchMode' : 'setDefaultAutoWatchMode',
        mode: $(this).val(),
        csrf: xm.form_token
      }).done(function() {
        notification.hide();
        new XWiki.widgets.Notification("Saved!", 'done');
      }).error(function() {
        notification.hide();
        new XWiki.widgets.Notification("Failed to save your settings", 'error');
      });
    });
  });

});
